/**************************************************************************
 *
 * Beispiel zum Alignment
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           $Date: 2007/09/19 $
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc align_bsp.c -o align_bsp
 *
 * Dieses Programm zeigt die Ausrichtung von Variablen im Arbeitsspeicher
 * am Beispiel der einer Datenstruktur.
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <stdlib.h>

	/* --- Typdeklarationen ----------------------------------------- */

struct gt_demo
{
  char   zeichen1;	     /* 1 Byte					  */
  char   zeichen2;	     /* 1 Byte					  */
  long   doppelwort;	     /* 4 Byte					  */
  char   zeichen3;	     /* 1 Byte					  */
  short  wort;		     /* 2 Byte					  */
  char   zeichen4;	     /* 1 Byte					  */
  double quadwort;	     /* 8 Byte					  */
};

	/* --- Funktionen ----------------------------------------------- */

int main ( void )

/* Hauptprogramm
 *
 * Argumente:
 *   keine
 *
 * Ergebnis:
 *   EXIT_SUCCESS
 *
 * Dieses Programm demonstriert die Auswirkungen des Alignments.
 */
{
  struct gt_demo
    demoVar;		     /* Variable mit der Struktor struct gt_demo  */

  
	  /* Gren der Struktur-Elemente anzeigen			  */
  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.zeichen1", sizeof ( demoVar.zeichen1 ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.zeichen2", sizeof ( demoVar.zeichen2 ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.doppelwort", sizeof ( demoVar.doppelwort ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.zeichen3", sizeof ( demoVar.zeichen3 ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.wort", sizeof ( demoVar.wort ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.zeichen4", sizeof ( demoVar.zeichen4 ) );

  printf ( "sizeof ( %-18s ) = %2d\n",
	   "demoVar.quadwort", sizeof ( demoVar.quadwort ) );

  printf ( "sizeof ( %-18s ) =  ? \n", "demoVar" );

  printf ( "\nWeiter mit <Enter>" );
  getchar();

  printf ( "sizeof ( %-18s ) = %2d \n",
	   "demoVar", sizeof ( demoVar ) );

  printf ( "\nWeiter mit <Enter>" );
  getchar();

  printf ( "%-18s|  Adresse   | Gre\n", "Variable" );
  
  printf ( "%-18s| %p | %3d \n",
	   "demoVar", &demoVar, sizeof ( demoVar ) );

  printf ( "%-18s| %p | %3d \n",
 	   "demoVar.zeichen1", &demoVar.zeichen1, sizeof ( demoVar.zeichen1 ));

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.zeichen2", &demoVar.zeichen2, sizeof ( demoVar.zeichen2 ));

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.doppelwort", &demoVar.doppelwort,
	                         sizeof ( demoVar.doppelwort ) );

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.zeichen3", &demoVar.zeichen3, sizeof ( demoVar.zeichen3 ));

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.wort", &demoVar.wort, sizeof ( demoVar.wort ) );

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.zeichen4", &demoVar.zeichen4, sizeof ( demoVar.zeichen4 ));

  printf ( "%-18s| %p | %3d \n",
	   "demoVar.quadwort", &demoVar.quadwort, sizeof ( demoVar.quadwort ));

  putchar ( '\n' );

  return EXIT_SUCCESS;	     /* Returncode: OK				  */
}
