/**************************************************************************
 *
 * Beispiel zu Prozessen
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           $Date: 2006/11/12 23:52:20 $
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc childproc.c -o childproc
 *
 * Dieses Programm soll das Verhalten von Prozessen sowie deren getrennte
 * Speicherbereiche zeigen. Dazu schreibt jeder Proze Informationen auf
 * den Bildschirm.
 *                                                                        
 * Beispiel fr das Ergebnis des Programmes auf dem Bildschirm:          
 *
 * PID 12381:  Programm gestartet 
 * PID 12382:  Dies ist der Kind-Prozess mit Proze-ID 12382
 * PID 12382 = Kind-Prozess  * sum  =     7 (alter Wert)
 * PID 12381:  Dies ist der Eltern-Prozess mit Proze-ID 12381
 * PID 12381 = Eltern-Prozess                  * sum  =     7 (alter Wert)
 * PID 12382 = Kind-Prozess  * sum  =    10 (neuer Wert)
 * PID 12382 = Kind-Prozess  * sum  =    10 (alter Wert)
 * PID 12381 = Eltern-Prozess                  * sum  =    15 (neuer Wert)
 * PID 12381 = Eltern-Prozess                  * sum  =    15 (alter Wert)
 * PID 12382 = Kind-Prozess  * sum  =     6 (neuer Wert)
 * PID 12382:  Kind-Prozess beendet sich selbst
 * PID 12381 = Eltern-Prozess                  * sum  =    11 (neuer Wert)
 * PID 12381 = Eltern-Prozess                  * sum  =    11 (alter Wert)
 * PID 12381 = Eltern-Prozess                  * sum  =    22 (neuer Wert)
 * PID 12381:  Ergebnis von wait() = 12382
 *
 *									  
 * Funktionen des Moduls:
 *
 *   main		()   Hauptprogramm
 *   AddData		()   Inhalt einer Variablen ndern und anzeigen
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/wait.h>


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: childproc.c,v 1.5 2006/11/12 23:52:20 phleps Exp $";


	/* --- Prototypen ----------------------------------------------- */

int main     ( void );

void AddData ( int * sum, int addItem, char * procName );


	/* --- Funktionen ----------------------------------------------- */

int main ( void )

/* Hauptprogramm
 *
 * Das Hauptprogramm ruft die Funktion ModifyProcData() sowohl direkt,
 * als auch in einem separaten Kindproze auf. Beide Prozesse schreiben
 * jeweils Daten zu ihrem Proze auf den Bildschirm.
 */
{
  pid_t
    childPid    = -999,	     /* Proze-ID des Kindprozesses		  */
    waitResult;		     /* Funktionsergebnis von wait()		  */

  int
    demoVar = 0;	     /* Variable, deren Inhalt zur Demonstration
			      * verndert wird. 			  */
  

  char
    * procName = "???";	     /* Prozebezeichnung: Eltern / Kind -Prozess */

    
  printf ( "PID %5d:  Programm gestartet \n", (int) getpid () );

	  /* Inhalt der Demo-Variablen ndern				  */ 
  demoVar = 7;

	  /* alle Zwischenpuffer des Betriebssystems leeren		  */
  fflush ( NULL );
  
	  /* Kindproze starten: fork() erzeugt eine Kopie des Proze-
	   * images. Den Code hinter fork() arbeiten beide Prozesse
	   * unabhngig voneinander ab.
	   *
	   * Der Eltern-Proze erhlt als Funktionsergebnis von fork()
	   * die Proze-ID des Kindprozesses. Der Kind-Proze erhlt
	   * den Wert 0 als Ergebnis von fork().			  */
  childPid = fork (); 

	  /* Returncode von fork() auswerten und unterschiedlichen Code
	   * fr Eltern- und Kindproze ausfhren			  */
  switch ( childPid )
  {
    case -1:		     /* Fehler beim starten des Kindprozesses:	  */
	perror ( "fork()" ); /* Fehlermeldung ausgeben			  */
	break;

    case 0:		     /* Kind-Proze:				  */
	procName = "Kind-Prozess";
	printf ( "PID %5d:  Dies ist der Kind-Prozess mit Proze-ID %d\n",
			     (int) getpid (),(int) getpid () );

		/* Inhalt der globalen Variablen ndern			  */
	AddData ( &demoVar, 3, procName );
	
	break;

    default:		     /* Eltern-Proze:				  */
	procName = "Eltern-Prozess                ";
	printf ( "PID %5d:  Dies ist der Eltern-Prozess mit Proze-ID %d\n",
			     (int) getpid (),(int) getpid () );

		/* Inhalt der globalen Variablen ndern			  */
	AddData ( &demoVar, 8, procName );

	break;
  }

		/* Inhalt der globalen Variablen nochmals ndern	  */
  AddData ( &demoVar, -4, procName );

	  /* Hier soll der Kind-Proze aufhren. 
	   * Ist dies der Kind-Proze?					  */
  if ( 0 == childPid )
  {
    printf ( "PID %5d:  %s beendet sich selbst\n",
			     (int) getpid (), procName );

    exit ( 0 );		     /* Kind-Proze beenden			  */
  }

	  /* Der folgende Code wird nur noch vom Eltern-Proze
	   * abgearbeitet.						  */

	  /* Inhalt der globalen Variablen nochmals ndern	  */
  AddData ( &demoVar, 11, procName );

	  /* Warten, bis der Kind-Proze fertig ist. Der Exit-Status des
	   * Kind-Prozesses wird hier nicht ausgewertet.		  */
  waitResult = wait ( NULL );

	  /* Fehler beim warten auf das Ende des Kindprozesses? 	  */
  if ( waitResult < 0 )
  {
	    /* Fehlermeldung ausgeben					  */
    perror ( "wait()" );
  }

	  /* Ergebnis von wait() anzeigen				  */
  printf ( "PID %5d:  Ergebnis von wait() = %5d\n",
	   (int) getpid (), (int) waitResult );

  return EXIT_SUCCESS;	     /* Returncode: OK				  */
}


void AddData ( int * sum, int addItem, char * procName )

/* Inhalt einer Variablen ndern und anzeigen
 *
 * Argumente:
 *   sum	in/out	Zeiger auf Variable, zu deren Inhalt der von addItem
 *			addiert wird
 *   addItem     in	Summand, der zu gvGlobalVar addiert wird
 *   procName	 in	Prozebezeichnung: Eltern- / Kind-Proze
 *
 * Globale Variablen:
 *   keine
 *
 *
 * Diese Funktion zeigt den bisherigen Inhalt der Summenvariablen an und
 * addiert den in addItem bergebenen Wert dazu. Nach einer kurzen Wartezeit
 * wird der neue Inhalt der Summenvariablen angezeigt.
 */ 
{
	  /* Inhalt der Summenvariablen anzeigen			  */
  printf ( "PID %5d = %s  * sum  = %5d (alter Wert)\n",
	   (int) getpid (), procName, * sum );
  
	  /* Inhalt der globalen Variablen ndern			  */
  * sum += addItem;

	  /* kurze Zeit warten						  */
  sleep ( 1 );
  
	  /* neuen Inhalt der globalen Variablen anzeigen		  */
  printf ( "PID %5d = %s  * sum  = %5d (neuer Wert)\n",
	   (int) getpid (), procName, * sum );
}
