/**************************************************************************
 *
 * Einfaches Beispiel zum berlagern eines Prozesses mit exec()
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           $Date: 2006/11/12 $
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc exec_simple.c -o exec_simple
 *
 * Dieses Programm soll die Wirkung der exec()-Funktionen zeigen:
 * Es ersetzt das eigene Programm in laufenden Prozess durch das Programm
 * neues_prog.
 *                                                                        
 *									  
 * Funktionen des Moduls:
 *
 *   main ()	     Hauptprogramm
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>
# include <stdlib.h>


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: //depot/rech_org/skript/src/exec_simple.c#1 $";


	/* --- Prototypen ----------------------------------------------- */

int main ( int argc, char * argv [] );


	/* --- Funktionen ----------------------------------------------- */

int main ( int argc, char * argv [] )

/* Hauptprogramm
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:                   Programmname
 *
 * Ergebnis:
 *   nicht definiert, da abhngig von Programm neues_prog
 *
 * Das Programm schreibt eine Meldung mit dem eigenen Programmnamen auf
 * den Bildschirm und startet dann mit execl() das Programm neues_prog.
 */
{
	  /* eigene Prozess-ID und eigenen Programmnamen ausgeben	  */
  printf ( "PID %5d: Programm %s gestartet \n", (int) getpid (), argv [ 0 ] );

	  /* Weiter mit Programm neues_prog in diesem Prozess. Das eigenes
	   * Programm wird dabei durch Programm neues_prog ersetzt.
	   * Wenn exec() erfolgreich war, kehrt die Funktion NIE zurck!  */
  execl ( "./neues_prog", "neues_prog", "Argument1", "Arg2", "Arg3", NULL );

	  /* Wenn exec() erfolgreich war, kehrt die Funktion NIE zurck.
	   * Der folgende Code wird nur im Fehlerfall ausgefhrt.	  */
  perror ( "execl()" );

	  /* Programm beenden. Exit-Status: Fehler			  */
  return EXIT_FAILURE;

}  /* Ende main () */

