/**************************************************************************
 *
 * Einfaches Beispiel zu Eltern- und Kind-Prozess
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           $Date: 2005/10/23 $
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc fork_simple.c -o fork_simple
 *
 * Dieses Programm soll die Wirkung der Funktion fork() zeigen.
 *                                                                        
 *									  
 * Funktionen des Moduls:
 *
 *   main ()	     Hauptprogramm
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/wait.h>


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: //depot/rech_org/skript/src/fork_simple.c#3 $";


	/* --- Prototypen ----------------------------------------------- */

int main          ( void );


	/* --- Funktionen ----------------------------------------------- */

int main ( void )

/* Hauptprogramm
 *
 * Das Programm schreibt eine Meldung auf den Bildschirm und ruft dann
 * fork () auf. Anschlieend schreiben Eltern- und Kindproze jeweils
 * ihr Ergebnis von fork() und ihre eigene Proze-Nummer auf den
 * Bildschirm.
 */
{
  pid_t
    forkResult, 	     /* Funktionsergebnis von fork() 		  */
    waitResult;		     /* Funktionsergebnis von wait()		  */

    
  printf ( "PID %5d: Programm gestartet \n", (int) getpid () );


	  /* alle Zwischenpuffer des Betriebssystems leeren		  */
  fflush ( NULL );
  
	  /* Kindproze starten: fork() erzeugt eine Kopie des Proze-
	   * images. Den Code hinter fork() arbeiten beide Prozesse
	   * unabhngig voneinander ab.					  */
  forkResult = fork ();

  printf ( "PID %5d: Ergebnis von fork() = %5d\n",
	   (int) getpid (), (int) forkResult );

	  /* Um Zombies zu verhindern muss der Eltern-Prozess irgendwann
	   * auf das Ende des Kind-Prozesses warten und dessen Exit-Status
	   * lesen!
	   * Um dieses Beispiel mglichst einfach zu halten, wird hier aus-
	   * nahmsweise nicht zwischen Eltern- und Kindprozess unterschieden.
	   * Im Kindprozess liefert wait() deshalb das Ergebnis "Fehler".
	   */
  waitResult = wait ( NULL );

  printf ( "PID %5d: Ergebnis von wait() = %5d\n",
	   (int) getpid (), (int) waitResult );

  return EXIT_SUCCESS;	     /* Returncode: OK				  */
}
