/**************************************************************************
 *
 * Beispiel zu einem Programm mit graphischer Bedienoberflche 
 *
 * Ersteller :       Ingo Phleps
 *
 * Stand :           $Date: 2005/02/03 $
 *
 * Zielsystem:       UNIX mit X11 bzw. OSF/Motif
 *
 * bersetzen:       cc -I/usr/X11R6/include -o gui_bsp -L/usr/X11R6/lib \
 *							-lXm gui_bsp.c
 *
 * Dieses Programm erzeugt ein Fenster mit einer Textausgabe und Buttons.
 * ber die Buttons knnen wahlweise weitere Fenster erzeugt, oder das
 * Programm beendet werden. 
 *									  
 * Das Programm zeigt die typische Programmstruktur eines Programms mit
 * graphischer Bedienoberflche und die daraus resultierende Ereignis-
 * orientierte Steuerung des Programmablaufs: Das Bettigen von Buttons
 * veranlat die Ereignis-Behandlung, die Callback-Funktion aufzurufen, die
 * fr den betreffenden Button registriert ist. 
 *
 * Funktionen des Moduls:
 *
 *   main           ()	Hauptprogramm
 *   InitWidgetTree ()	Widget-Baum aufbauen
 *   AddWindowCB    ()	Callback-Funktion fr Button "Neues Fenster"
 *   CloseWindowCB  ()	Callback-Funktion fr Button "Fenster schlieen"
 *   ExitCB	    ()	Callback-Funktion fr Button "Programm beenden"
 *                                                                        
 **************************************************************************/

# include <stdlib.h>

	/* Include-Dateien fr graphische Oberflche (OSF-Motif)	  */
# include <Xm/Xm.h>
# include <Xm/Form.h>	/* Header-Dateien fr verwendete Widget-Klassen	  */
# include <Xm/Label.h>
# include <Xm/PushB.h>


	/* --- Konstanten ----------------------------------------------- */

	/* Klassen-Name der Anwendung					  */
# define APPL_CLASS	"XmGuiBsp"


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: //depot/rech_org/skript/src/gui_bsp.c#1 $";


	/* --- Prototypen ----------------------------------------------- */

	/* Hauptprogramm						  */
void main           ( int argc, char * argv [] );

	/* Widget-Baum aufbauen						  */
void InitWidgetTree ( Widget shellWidget );

	/* Callback-Funktion fr Button "Neues Fenster"			  */
void AddWindowCB   ( Widget widget, XtPointer clientData, XtPointer callData );

	/* Callback-Funktion fr Button "Fenster schlieen"		  */
void CloseWindowCB ( Widget widget, XtPointer clientData, XtPointer callData );

	/* Callback-Funktion fr Button "Programm beenden"		  */
void ExitCB	   ( Widget widget, XtPointer clientData, XtPointer callData );



	/* --- Funktionen ----------------------------------------------- */

void main ( int argc, char * argv [] )

/* Hauptprogramm
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs
 *
 * Das Hauptprogramm initialisiert die graphische Bedienoberflche,
 * baut den Widget-Baum auf und startet dann die Hauptschleife mit der
 * Ereignis-Behandlung. Dieser Ablauf ist fr graphische Oberflchen typisch. 
 *
 * Das Hauptprogramm ist ausnahmsweise vom Typ void, da aus der von main()
 * aufgerufenen Hauptschleifenfunktion niemals ein Rcksprung erfolgt.
 * Das Programm wird mit der Funktion exit() beendet, die dann den Exit-
 * Status bergibt. 
 */
{
  XtAppContext kontext;	     /* Applikations-Umgebung			  */

  Widget applShell;	     /* Application-Shell			  */

  
	  /* Initialisieren, Application-Shell erzeugen			  */
  applShell = XtAppInitialize ( & kontext, APPL_CLASS,
				(XrmOptionDescRec *) NULL, 0,
                                 &argc, argv,
				(String *) NULL, (Arg *) NULL, 0);

	  /* Widget-Baum unterhalb der Application-Shell aufbauen.	  */
  InitWidgetTree ( applShell );

	  /* Widget-Baum anzeigen					  */
  XtRealizeWidget ( applShell );

	  /* Hauptschleife mit Ereignis-Behandlung
	   * Aus dieser Funktion kehrt das Programm nie zurck!		  */
  XtAppMainLoop ( kontext );

}    /* Ende main () */



void InitWidgetTree ( Widget shellWidget )

/* Widget-Baum aufbauen
 *
 * Diese Funktion baut den Widget-Baum fr das bergebene Shell-Widget auf.
 *
 * Das Fenster besteht aus einem Container, der das "Label" zur Text-Anzeige
 * sowie die Buttons enthlt.
 * Bei Graphischen Bedienoberflchen sind die Elemente der Oberflche
 * ("Widgets") hierarchisch angeordnet. Daraus ergibt sich eine Baum-Struktur.
 *
 * Widget-Baum des von InitWidgetTree() erzeugten Fensters:
 *
 *                            shellWidget
 *                                 |
 *                             Container
 *                              (XmForm)
 *                                 |
 *       +--------------+----------+---------+----------------------+
 *       |              |                    |                      |
 *  Text-Anzeige      Button              Button                 Button
 *   (XmLabel)    "Neues Fenster"    "Fenster schlieen"    "Programm beenden"
 *                (XmPushButton)       (XmPushButton)         (XmPushButton)
 *
 * Der Button "Fenster schlieen" entfllt beim Fenster fr die Application
 * Shell.
 *
 * In diesem Beispielprogramm ist das Fenster, das zu Beginn des Programms
 * erzeugt wird, fast gleich wie das Fenster, das durch den Button
 * "Neues Fenster" erzeugt werden soll. Die Funktion InitWidgetTree wird
 * deshalb nicht nur von main() aufgerufen, sondern in diesem Programm
 * ausnahmsweise auch von AddWindowCB(). 
 */
{
  static int winCount;	     /* Zhler fr Fenster-Nummer		  */
  
  Widget
    formWidget,		     /* Container-Widget fr die anderen Widgets
			      * des Fensters				  */
    labelWidget,	     /* Widget zur Anzeige der Fenster-Nummer	  */
    widget;		     /* Widget fr verschiedene Buttons		  */

  int argc;		     /* Zahl der besetzten Elemente in args []	  */

  Arg args [10];	     /* Argumente fr Widget			  */

  char labelString [80];     /* Text zur Anzeige im Label		  */

  
	  /* Container-Widget fr andere Widgets erzeugen		  */
  formWidget = XmCreateForm ( shellWidget, "form", (Arg *) NULL, 0 );
  XtManageChild ( formWidget );

	  /* Zhler fr Fensternummer weiterzhlen und String fr die
	   * Anzeige vorbereiten					  */
  winCount ++ ;
  sprintf ( labelString, "Dies ist Fenster Nr. %d", winCount );

	  /* Position des Label-Widgets innerhalb des Form-Widgets
	   * festlegen							  */
  argc = 0;
  XtSetArg ( args [ argc ], XmNtopAttachment,   XmATTACH_FORM ); argc ++ ;
  XtSetArg ( args [ argc ], XmNleftAttachment,  XmATTACH_FORM ); argc ++ ;
  XtSetArg ( args [ argc ], XmNrightAttachment, XmATTACH_FORM ); argc ++ ;

	  /* Label-Widget zur Anzeige des Textes erzeugen		  */
  labelWidget = XmCreateLabel ( formWidget, labelString, args, argc );
  
	  /* Label-Widget im Layout seines Eltern-Widgets bercksichtigen */
  XtManageChild ( labelWidget );


	  /* Push-Buttons erzeugen:
	   * Button "Neues Fenster", unten links			  */
  argc = 0;
  XtSetArg ( args [ argc ], XmNtopAttachment,  XmATTACH_WIDGET ); argc ++ ;
  XtSetArg ( args [ argc ], XmNtopWidget,      labelWidget     ); argc ++ ;
  XtSetArg ( args [ argc ], XmNleftAttachment, XmATTACH_FORM   ); argc ++ ;
  
  widget = XmCreatePushButton ( formWidget, "Neues Fenster", args, argc );
  XtManageChild ( widget );

	  /* Callback-Funktion fr diesen Button setzen			  */
  XtAddCallback ( widget, XmNactivateCallback,
                  AddWindowCB, (XtPointer) NULL );


	  /* Das erste Fenster, d. h. das Fenster der Application Shell,
	   * bekommt keinen Button "Fenster schlieen".
	   *
	   * Ist dies nicht das erste Fenster?				  */
  if ( winCount > 1 )
  {
	    /* Button "Fenster schlieen", unten Mitte			  */
    argc = 0;
    XtSetArg ( args [ argc ], XmNtopAttachment,  XmATTACH_WIDGET ); argc ++ ;
    XtSetArg ( args [ argc ], XmNtopWidget,      labelWidget     ); argc ++ ;
    XtSetArg ( args [ argc ], XmNleftAttachment, XmATTACH_WIDGET ); argc ++ ;
    XtSetArg ( args [ argc ], XmNleftWidget,     widget          ); argc ++ ;

    widget = XmCreatePushButton ( formWidget, "Fenster schlieen",
				  args, argc );
    XtManageChild ( widget );

	    /* Zum schlieen des Fensters mu die Callback-Funktion das
	     * zum Fenster gehrende Shell-Widget kennen. Das Shell-Widget
	     * wird deshalb hier zur bergabe an die Callback-Funktion
	     * bereitgestellt.						  */
    XtAddCallback ( widget, XmNactivateCallback,
		    CloseWindowCB, (XtPointer) shellWidget );
  }

  	   /* Button "Programm beenden", unten rechts			  */
  argc = 0;
  XtSetArg ( args [ argc ], XmNtopAttachment,   XmATTACH_WIDGET ); argc ++ ;
  XtSetArg ( args [ argc ], XmNtopWidget,       labelWidget     ); argc ++ ;
  XtSetArg ( args [ argc ], XmNleftAttachment,  XmATTACH_WIDGET ); argc ++ ;
  XtSetArg ( args [ argc ], XmNleftWidget,      widget          ); argc ++ ;
  XtSetArg ( args [ argc ], XmNrightAttachment, XmATTACH_FORM   ); argc ++ ;
  
  widget = XmCreatePushButton ( formWidget, "Programm beenden", args, argc );
  XtManageChild ( widget );

	  /* Callback-Funktion fr diesen Button setzen			  */
  XtAddCallback ( widget, XmNactivateCallback, ExitCB, (XtPointer) NULL );

}    /* Ende InitWidgetTree ()  */


void AddWindowCB ( Widget widget, XtPointer clientData, XtPointer callData )

/* Callback-Funktion fr Button "Neues Fenster"
 *
 * Argumente:
 *   widget	  in	Widget, das den Callback aufruft; hier nicht verwendet
 *   clientData	  in	Daten, die beim Registrieren des Callbacks bergeben
 *			wurden; hier nicht verwendet
 *   callData	  in	Aufruf-Daten; hier nicht verwendet
 *
 * Diese Funktion erzeugt eine neue Shell mit einem neuen Fenster. 
 */
{
  Widget shell;

  shell = XtCreatePopupShell ( "Neues Fenster", topLevelShellWidgetClass,
			       widget, (Arg *) NULL, 0 );

  InitWidgetTree ( shell );

  XtPopup ( shell, XtGrabNone );
}


void CloseWindowCB ( Widget widget, XtPointer clientData, XtPointer callData )

/* Callback-Funktion fr Button "Fenster schlieen"
 *
 * Argumente:
 *   widget	  in	Widget, das den Callback aufruft; hier nicht verwendet
 *   clientData   in	Client-Daten: Shell des zu schlieenden Fensters.
 *			Sie wurde beim Registrieren des Callbacks bergeben.
 *   callData	  in	Aufruf-Daten; hier nicht verwendet
 *
 * Diese Funktion schliet das Fenster, dessen Button "Fenster schlieen"
 * bettigt wurde. 
 */
{
  XtPopdown ( (Widget) clientData );
}


void ExitCB ( Widget widget, XtPointer clientData, XtPointer callData )

/* Callback-Funktion fr Button "Programm beenden"
 *
 * Argumente:
 *   widget	  in	Widget, das den Callback aufruft; hier nicht verwendet
 *   clientData	  in	Daten, die beim Registrieren des Callbacks bergeben
 *			wurden; hier nicht verwendet
 *   callData	  in	Aufruf-Daten; hier nicht verwendet
 *
 * Diese Funktion beendet das Programm mit dem Exit-Status "kein Fehler". 
 */
{
  exit ( EXIT_SUCCESS );
}

