/**************************************************************************
 *
 * Eigene Prozessnummer, Programmnamen und Argumente des Aufrufs ausgeben
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           $Date: 2006/11/12 $
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc neues_prog.c -o neues_prog
 *
 * Dieses Programm zeigt nur seine Identitt und Aufrufparameter an.
 * Es dient als Beispiel fr den Aufruf eines Programms mit exec(),
 * z. B. im Programm exec_simple.
 *                                                                        
 *									  
 * Funktionen des Moduls:
 *
 *   main ()	     Hauptprogramm
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>
# include <stdlib.h>


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: //depot/rech_org/skript/src/neues_prog.c#1 $";


	/* --- Prototypen ----------------------------------------------- */

int main ( int argc, char * argv [] );


	/* --- Funktionen ----------------------------------------------- */

int main ( int argc, char * argv [] )

/* Hauptprogramm
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:                   Programmname
 *			  argv [1] bis argv[argc -1]: Optionen und Argumente
 *
 * Ergebnis:
 *   EXIT_SUCCESS
 *
 * Das Programm schreibt eine Meldung mit der eigenen Prozess-ID und dem
 * eigenen Programmnamen auf den Bildschirm. Sofern vorhanden, werden auch
 * die weiteren Argumente des Programmaufrufs ausgegeben. 
 */
{
  int
    argIndex;		     /* Index fr argv[]			  */
  
	  /* eigene Prozess-ID und eigenen Programmnamen ausgeben	  */
  printf ( "PID %5d: Programm %s gestartet \n", (int) getpid (), argv [ 0 ] );

	  /* weitere Argumente anzeigen, sofern vorhanden		  */
  for ( argIndex = 1; argIndex < argc; argIndex ++ )
  {
    printf ( "      argv [ %d ] = %s\n", argIndex, argv [ argIndex ] );
  }

	  /* Programm beenden. Exit-Status: Kein Fehler			  */
  return EXIT_SUCCESS;

}  /* Ende main () */

