/**************************************************************************
 *
 * Eigene Prozenummer, Programmnamen und -argumente ausgeben
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           01.11.2000
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * Dieses Modul enthlt Funktionen, die von anderen Modulen zur Ausgabe
 * ihrer Daten verwendet werden.
 *
 * Vor dem ersten Aufruf von PrintArgs() sollten PrintHeader() zum Ausgeben
 * der Spaltenberschriften aufgerufen werden. 
 *
 *									  
 * Funktion des Moduls:
 *
 *   PrintHeader	()   Spaltenberschriften fr Ausgaben von
 *			     PrintArgs() ausgeben
 *   PrintArgs		()   Label, eigene Prozenummer, Programmnamen
 *			     und -argumente ausgeben
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>	     /* wegen getpid ()				  */

# include "printargs.h"	     /* Prototyp fr PrintArgs()		  */


	/* --- Symbolische Konstanten ----------------------------------- */

	/* max. Anzahl der anzuzeigenden Argumente der Kommandozeile,
	 * damit die Ausgabe noch in eine Zeile mit 80 Zeichen pat	  */
# define MAX_ARGS	3

	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: printargs.c,v 1.1 2000/11/01 19:24:38 phleps Exp $";


	/* --- Prototypen ----------------------------------------------- */


	/* --- Funktionen ----------------------------------------------- */

void PrintHeader ( void )

/* Spaltenberschriften fr Ausgaben von PrintArgs() ausgeben
 *
 * Argumente:
 *   keine
 *
 * Die Funktion schreibt die Spaltenberschriften fr die Ausgaben von
 * PrintArgs() nach stdout.
 * Das anwendende Programm mu selbst dafr sorgen, da diese Funktion
 * vor dem ersten Aufruf von PrintArgs() einmal aufgerufen wird.
 */
{
  int
    argIndex;		     /* Index fr argv[]			  */


	  /* Label, Proze-ID und Programmnamen ausgeben		  */
  printf ( "%-25.25s  %5s  %-12.12s", "Label", "PID", "argv [0]" );

	  /* falls vorhanden, weitere Argumente ausgeben		  */
  for ( argIndex = 1 ; argIndex <= MAX_ARGS ; argIndex ++ )
  {
    printf ( " argv [%1d] ", argIndex );
  }

	  /* Zeile abschlieen						  */
  fputc ( '\n', stdout );
}


void PrintArgs ( const char * label, int argc, char * const argv[] )

/* Label, eigene Prozenummer, Programmnamen und -argumente ausgeben
 *
 * Argumente:
 *   label	in	String zur Kennzeichnung der Stelle, an der die
 *			Funktion aufgerufen wird. 
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:                   Programmname
 *			  argv [1] bis argv[argc -1]: Optionen, Argumente
 *
 * Die Funktion schreibt den Text des Labels, die Nummer des eigenen
 * Prozesses und den Inhalt der Elemente in argv[0] bis argv[MAX_ARGS]
 * nach stdout. 
 * Die Daten jedes Funktionsaufrufs werden jeweils in einer Zeile
 * ausgegeben. Damit die Daten in eine Zeile mit 80 Zeichen passen, werden
 * fr argv[] nur jeweils eine begrenzte Anzahl Zeichen ausgegeben.
 *
 * Vor dem ersten Aufruf dieser Funktion sollte PrintHeader () aufgerufen
 * werden. 
 */
{
  int
    argIndex;		     /* Index fr argv[]			  */


	  /* Label, Proze-ID und Programmnamen ausgeben		  */
  printf ( "%-25.25s  %5d  %-12.12s", label, getpid(), argv [0] );

	  /* falls vorhanden, weitere Argumente ausgeben		  */
  for ( argIndex = 1 ;
	argIndex < argc  &&  argIndex <= MAX_ARGS ;
	argIndex ++ )
  {
	    /* max. 9 Zeichen pro Argument ausgeben			  */
    printf ( " %-9.9s", argv[argIndex] );
  }

	  /* Zeile abschlieen						  */
  fputc ( '\n', stdout );
}
