/**************************************************************************
 *
 * Eigene Prozenummer, Programmnamen und Argumente des Aufrufs ausgeben
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           01.11.2000
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc progbsp.c printargs.c -o progbsp
 *
 * Dieses Programm soll zusammen mit startprog.c den Ablauf beim Start
 * eines Programms zeigen. 
 *
 *									  
 * Funktionen des Moduls:
 *
 *   main		()   Hauptprogramm
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>	     /* wegen getpid ()				  */
# include <stdlib.h>	     /* wegen EXIT_SUCCESS			  */

# include "printargs.h"	     /* Prototyp fr PrintArgs()		  */


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: progbsp.c,v 1.1 2000/11/01 19:24:38 phleps Exp $";


	/* --- Prototypen ----------------------------------------------- */

int main ( int argc, char * argv[] );


	/* --- Funktionen ----------------------------------------------- */

int main ( int argc, char * argv[] )

/* Hauptprogramm
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:                   Programmname
 *			  argv [1] bis argv[argc -1]: Optionen und Argumente
 *
 * Ergebnis:
 *   EXIT_SUCCESS
 *
 * Das Programm schreibt die eigene Prozenummer und den Inhalt der Elemente
 * von argv[] nach stdout.
 */
{
	  /* Informationen zum eigenen Programm ausgeben		  */
  PrintArgs ( "Neues Programm", argc, argv );
  
  return EXIT_SUCCESS;	     /* Returncode: OK				  */
}
