/**************************************************************************
 *
 * Beispiel zu Shared Memory: 
 * Gemeinsame Funktionen fr shm_send.c und shm_recv.c
 *                                                                        
 * Ersteller:	Ingo Phleps                                          
 *                                                                        
 * Stand:	23.03 2003
 *
 * Zielsystem:	UNIX                                                 
 *                                                                        
 * Beispiel zur Vorlesung "Rechnerorganisation"     5. und 6. Halbjahr
 * Fachrichtung Nachrichtentechnik an der Berufsakademie Stuttgart
 *
 * Dieses Modul enthlt Funktionen zum Beispiel zu Shared Memories, die
 * sowohl vom Programm shm_send, als auch vom Program shm_recv verwendet
 * werden.
 *									  
 * Funktionen des Moduls:
 *
 *   ReadArg		()   Key fr Shared Memory aus Befehlszeile lesen
 *   AskForMore		()   Auf Eingabe fr Fortsetzung warten und Eingabe
 *			     auswerten
 *                                                                        
 **************************************************************************/

	/* Shared Memories sind nicht Teil des POSIX-Standards, sondern
	 * im XPG-Standard definiert!					  */
# define _XOPEN_SOURCE

# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/ipc.h>	     /* notwendig fr Typ key_t			  */

# include "shm_common.h"



/*  */
	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: //depot/rech_org/skript/src/shm_common.c#1 $";



	/* --- Funktionen ----------------------------------------------- */

int ReadArg ( int argc, char * argv[], key_t * shmKey )

/* Schlssel zur Auswahl des Shared Memories aus Befehlszeile lesen
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:  Programmname
 *			  argv [1]:  Key zur Auswahl des Shared Memories
 *   shmKey	out	Zeiger auf Ziel fr Schlssel zur Auswahl des
 *			Shared Memories 
 *
 * Ergebnis:
 *   EXIT_SUCCESS	Kein Fehler: Schlssel fr Auswahl des Shared
 *			     Memories in *shmKey eingetragen
 *
 *   EXIT_FAILURE	Fehler: Schlssel fr Auswahl des Shared Memories
 *			     konnte nicht gelesen werden.
 *			     Fehlermeldung wurde ausgegeben und
 *			     *shmKey = SHM_ID_INVALID gesetzt.
 *
 * Die Funktion liest den Key zur Auswahl des Shared Memories aus der
 * Befehlszeile des Programmaufrufs und schreibt den Schlssel nach *shmKey.
 *
 * Wenn dies wegen eines Fehlers nicht mglich war, gibt die Funktion eine
 * Fehlermeldung aus.
 */
{
  char
    * progName;		     /* Name dieses Programms			  */

	  /* Name des Programms aus der Befehlszeile festhalten		  */
  progName = argv[0];

	  /* Zielvariable fr SHM-ID mit Wert 'ungltig' vorbesetzen	  */
  * shmKey = SHM_ID_INVALID;

	  /* Aufruf ohne Argument?					  */
  if ( argc < 2 )
  {
	    /* Fehlermeldung, Ergebnis = "Fehler"			  */
    fprintf ( stderr, "\n%s: Fehler: Argument mit Zahl fr SHM-Key fehlt!\n",
	                   progName );
    fprintf ( stderr,   "        Programm wird abgebrochen.\n" );
    fprintf ( stderr, "\n        Aufruf: %s SHM-Key\n", progName );
    fprintf ( stderr,   "                mit Dezimalzahl fr SHM-Key \n\n" );

    return EXIT_FAILURE;     /* Ergebnis: Fehler			  */
  }
	  /* SHM-Key lesen, Format umwandeln und in Zielvariable
	   * eintragen.
	   * Kein numerisches Argument fr SHM-Key?			  */
  else if ( 1 != sscanf ( argv[1], "%d", shmKey ) )
  {
	    /* Fehlermeldung, Ergebnis = "Fehler"			  */
    fprintf ( stderr,
	      "\n%s: Fehler: 1. Argument fr SHM-Key ist keine Dezimalzahl!\n",
	                   progName );
    fprintf ( stderr,   "        Programm wird abgebrochen.\n" );
    fprintf ( stderr, "\n        Aufruf: %s SHM-Key\n", progName );
    fprintf ( stderr,   "                mit Dezimalzahl fr SHM-Key \n\n" );

    return EXIT_FAILURE;     /* Ergebnis: Fehler			  */
  }

  return EXIT_SUCCESS;	     /* Ergebnis: Kein Fehler			  */

}  /*  Ende  ReadArg ()  */


int AskForMore ( const char * action )

/* Auf Eingabe fr Fortsetzung warten und Eingabe auswerten
 *
 * Argumente:
 *   action	in	Stichwort der AKton, die das Programm ausfhrt
 *
 * Ergebnis:
 *   TRUE		Zeichen != 'n' eingegeben, weitere Aktion durchfhren
 *   FALSE		'n' eingegeben, keine weiteren Aktionen mehr ausfhren
 *
 * Die Funktion schreibt eine Aufforderung zur Eingabe auf den Bildschirm
 * und wartet danach auf eine Eingabe.
 * Das erste Zeichen der Eingabe wird ausgewertet und das zugehrige
 * Funktionsergebnis zurckgegeben.
 */
{
  char			
    inputLine [ 80 ];	     /* Eingabezeile; Lnge willkrlich gewhlt	  */

  
	  /* Hinweis auf erwartete Eingabe ausgeben			  */
  printf ( "Weitere Nachrichten %s (*/n)  ", action );

	  /* Antwort lesen						  */
  fgets ( inputLine, sizeof ( inputLine ), stdin );

	  /* weitere Aktion durchfhren?				  */
  if ( 'n' != inputLine [0] )
  {
    return TRUE;	     /* Ergebnis: weitere Aktion durchfhren	  */
  }

  return FALSE;		     /* Ergebnis: keine weitere Aktion ausfhren  */

}  /*  Ende  AskForMore ()  */

