/**************************************************************************
 * $Header$
 *
 * Headerdatei zur Deklaration von Konstanten, Typen und Prototypen fuer
 * das Beispiel zu Shared Memories
 *
 * Ersteller:	Ingo Phleps                                          
 *
 * Stand:	23.03.2003
 *
 * Beispiel zur Vorlesung "Rechnerorganisation"     5. und 6. Halbjahr
 * Fachrichtung Nachrichtentechnik an der Berufsakademie Stuttgart
 * 
 **************************************************************************/
/*
 * $Log$
 **************************************************************************/

/* ---- Sperre gegen rekursiven Aufruf: --------------------------------- */

# ifndef SHM_COMMON_INCLUDED
# define SHM_COMMON_INCLUDED

static char                  /* RCS-Versionsnummer fr 'ident' u. 'what'  */
  * shmCommonHeader = "@(#)$Header$";


/* ---- allgemeine und projektspezifische Include-Dateien --------------- */



/* ---- Symbolische Konstanten, Makros: # define ... -------------------- */

# ifndef TRUE
#  define TRUE		1
#  define FALSE		0
# endif

			     /* Kennzeichen fr ungltige SHM-ID	  */
# define SHM_ID_INVALID	-1

			     /* max. Lnge einer Nachricht im Shared
			      * Memory					  */
# define MAX_TEXT_LEN	80


/* ---- Aufzaehlungstypen: enum ... ------------------------------------- */



/* ---- Typdeklarationen: ----------------------------------------------- */

	/* Struktur der Daten im Shared Memory.
	 * Die Datenstruktur wurde willkrlich festgelegt		  */
struct gt_shmData
{
  pid_t
    sendPid;		     /* Proze-ID des sendenden Prozesses	  */
  
  char		  	     /* Text zur bergabe an anderen Proze	  */
    shmText [MAX_TEXT_LEN +1];
};


/* ---- Deklaration globaler Variablen: --------------------------------- */



/* ---- Funktionsprototypen: -------------------------------------------- */


	/* Schlssel zur Auswahl des Shared Memories aus Befehlszeile
	 * lesen							  */
int ReadArg ( int argc, char * argv[], key_t * shmKey );


	/* Auf Eingabe fr Fortsetzung warten und Eingabe auswerten	  */
int AskForMore ( const char * action );


# endif /* SHM_COMMON_INCLUDED */
