/**************************************************************************
 *
 * Beispiel zum starten eines Programms
 *                                                                        
 * Ersteller :       Ingo Phleps                                          
 *                                                                        
 * Stand :           01.11.2000
 *                                                                        
 * Zielsystem:       UNIX                                                 
 *                                                                        
 * bersetzen:       cc startprog.c  printargs.c -o startprog
 *
 * Dieses Programm soll den Ablauf beim starten eines Programms zeigen.
 * Dazu wird das Programm "progbsp" gestartet, das im aktuellen Verzeich-
 * nis stehen mu!
 *
 * Die einzelnen Schritte des Ablaufs werden mit Hilfe der Funktion
 * PrintArgs() dokumentiert.
 *                                                                        
 * Beispiel:
 *   Programmaufruf:	./startprog abc defg
 *
 * Ergebnis des Programmes auf dem Bildschirm:
 * 
 * Label                        PID  argv [0]     argv [1]  argv [2]  argv [3]
 * Start                       1664  ./startprog  abc       defg     
 * Elternproze nach fork()    1664  ./startprog  abc       defg     
 * Kindproze nach fork()      1665  ./startprog  abc       defg     
 * Neues Programm              1665  progbsp      Argument1 Arg2      Arg3     
 * Ende                        1664  ./startprog  abc       defg     
 *
 *									  
 * Funktionen des Moduls:
 *
 *   main		()   Hauptprogramm
 *                                                                        
 **************************************************************************/

# include <stdio.h>
# include <unistd.h>	     /* wegen getpid ()				  */
# include <stdlib.h>	     /* wegen EXIT_SUCCESS			  */
# include <sys/types.h>	     /* wegen pid_t				  */
# include <sys/wait.h>	     /* wegen waitpid()				  */

# include "printargs.h"	     /* Prototyp fr PrintArgs()		  */


	/* --- Typdeklarationen ----------------------------------------- */


	/* --- globale Variablen ---------------------------------------- */

static char                  /* RCS-Versionsnummer ...                    */
  * header = "$Id: startprog.c,v 1.1 2000/11/01 19:24:38 phleps Exp $";

  
	/* --- Prototypen ----------------------------------------------- */

int main ( int argc, char * argv[] );


	/* --- Funktionen ----------------------------------------------- */

int main ( int argc, char * argv[] )

/* Hauptprogramm
 *
 * Argumente:
 *   argc	in	Zahl der Elemente in argv[]
 *   argv	in	Elemente der Kommandozeile des Programmaufrufs:
 *			  argv [0]:                   Programmname
 *			  argv [1] bis argv[argc -1]: Optionen und Argumente
 *
 * Ergebnis:
 *   EXIT_SUCCESS
 *
 * Das Hauptprogramm startet zunchst einen Kindproze. Der Speicher
 * dieses Kindprozesses wird dann durch das Programm 'progbsp' ersetzt.
 * Nach den einzelnen Schritten wird PrintArgs() aufgerufen, um den
 * jeweiligen Zustand anzuzeigen.
 */
{
  pid_t
    childPid    = -999;	     /* Proze-ID des Kindprozesses		  */


	  /* Spaltenberschriften ausgeben				  */
  PrintHeader ();

	  /* Programmstart anzeigen					  */
  PrintArgs ( "Start", argc, argv );

	  /* alle Zwischenpuffer des Betriebssystems leeren		  */
  fflush ( NULL );
  
	  /* Kindproze starten, Ergebnis von fork() auswerten		  */
  switch ( childPid = fork () )
  {
    case -1:		     /* Fehler beim starten des Kindprozesses:	  */
	perror ( "fork()" ); /* Fehlermeldung ausgeben			  */
	break;

    case 0:		     /* Kind-Proze:				  */
		/* Zustand ausgeben					  */
	PrintArgs ( "Kindproze nach fork()", argc, argv );

		/* anderes Programm in diesem Kindproze ausfhren	  */
	execl ( "./progbsp", "progbsp", "Argument1", "Arg2", "Arg3", NULL );

		/* Wenn exec() erfolgreich war, kehrt die Funktion NIE
		 * zurck. Der folgende Code wird nur im Fehlerfall aus-
		 * gefhrt.						  */
	perror ( "execl()" );

	PrintArgs ( "Fehler nach execl()", argc, argv );

		/* Proze abbrechen, Returncode 'Fehler'		  */
	exit ( EXIT_FAILURE );
		/* NOTREACHED */
	break;	/* Nur der Ordnung halber. Sicher ist sicher.		  */

    default:		     /* Eltern-Proze:				  */
	PrintArgs ( "Elternproze nach fork()", argc, argv );

	break;
  }

	  /* Ende des Kindprozesses abwarten. Dessen Exit-Status wird
	   * hier nicht ausgewertet					  */
  wait ( NULL );

  PrintArgs ( "Ende", argc, argv );

  return EXIT_SUCCESS;	     /* Returncode: OK				  */
}
